/*
*******************************************************************************
*
* File:		pxcibeh.h
* Description:  Function declarations for completer initiator behavior
* Author: 	Henrik Liebau
* Created: 	05 Apr 2000, 09:24:05
* Modified:     Wed Jun  7 18:22:35 2000 by Henrik Liebau, BVS R&D
* Language:	C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer 
* Status: 	
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxcibeh_H__
#define __pxcibeh_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxbehdef_H__
#include <pxbehdef.h>
#endif /* defined __pxbehdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 * BestXPprCIDefaultSet 
 * CLI abbrev.: pprcidefaultset
 *
 * Set all settings concerning the completer initiator to default values 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIDefaultSet (	       /* @pprcidefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehPermDefaultSet 
 * CLI abbrev.: pprcibehpermdefaultset
 *
 * Set PPR Ri Behavior perm settings to defaults 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehPermDefaultSet (    /* @pprcibehpermdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehPermSet 
 * CLI abbrev.: pprcibehpermset prop=<permprop> val = <value>
 *
 * Set PPR Behavior completer initiator settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehPermSet (	       /* @pprcibehpermset */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 value				       /* @val */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehPermGet 
 * CLI abbrev.: pprcibehpermget prop=<permprop> val = <value>
 *
 * Get PPR Behavior completer initiator settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehPermGet (	       /* @pprcibehpermget */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%08lx\\h" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehListDefaultSet 
 * CLI abbrev.: pprcibehlistdefaultset beh = <behavior>
 *
 * set variation list for completer initiator behaviors to default 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehListDefaultSet (    /* @pprcibehlistdefaultset */
  bx_handletype handle,
  bx_cibehtype behavior				       /* @beh */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehListSet 
 * CLI abbrev.: pprcibehlistset beh = <behavior> list = <list>
 *
 * set variation list for completer initiator behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehListSet (	       /* @pprcibehlistset */
  bx_handletype handle,
  bx_cibehtype behavior,			       /* @beh */
  bxppr_listtype list				       /* @list */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehListGet 
 * CLI abbrev.: pprcibehlistget beh = <behavior> list = <list>
 *
 * get variation list for completer initiator behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehListGet (	       /* @pprcibehlistget */
  bx_handletype handle,
  bx_cibehtype behavior,			       /* @beh */
  bxppr_listtype * pList			       /* #RETURN "%s" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCIBehResultGet 
 * CLI abbrev.: pprcibehresultget prop = <resultprop>
 *
 * get permutation result for selected resultprop parameter 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCIBehResultGet (	       /* @pprcibehresultget */
  bx_handletype handle,
  bxppr_behresulttype resultprop,		       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%lu" */
 );

/*****************************************************************************
 * functions used internally
 *****************************************************************************/

#ifdef PPRX_EXPORTS

/*---------------------------------------------------------------------------*
 * bx_errtype PprCIBehProg ( bx_handletype handle,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprCIBehProg ( bx_handletype handle,
			  bxppr_vardatatype * varData,
			  bxppr_behresultdatatype * behResult );

/*---------------------------------------------------------------------------*
 * bx_errtype PprCIBehResultCompute ( bxppr_behresultdatatype * behResult )
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprCIBehResultCompute ( bxppr_vardatatype * varData,
				   bxppr_behresultdatatype * behResult );

#endif /* defined PPRX_EXPORTS */


#ifdef __cplusplus
}
#endif


#endif /* defined __pxcibeh_H__ */
